Ext.data.JsonP.sol_common_SordUtils({"tagname":"class","name":"sol.common.SordUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.SordUtils.js","href":"lib_sol.common.SordUtils.html#sol-common-SordUtils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"eloas":true,"elojc":true,"requires":["sol.common.Cache","sol.common.ObjectFormatter","sol.common.StringUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"docMaskCache","tagname":"property","owner":"sol.common.SordUtils","id":"property-docMaskCache","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"pilcrow","tagname":"property","owner":"sol.common.SordUtils","id":"property-pilcrow","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addRights","tagname":"method","owner":"sol.common.SordUtils","id":"method-addRights","meta":{}},{"name":"changeMask","tagname":"method","owner":"sol.common.SordUtils","id":"method-changeMask","meta":{}},{"name":"cloneSord","tagname":"method","owner":"sol.common.SordUtils","id":"method-cloneSord","meta":{}},{"name":"createSord","tagname":"method","owner":"sol.common.SordUtils","id":"method-createSord","meta":{}},{"name":"decObjKeyValue","tagname":"method","owner":"sol.common.SordUtils","id":"method-decObjKeyValue","meta":{}},{"name":"docMaskExists","tagname":"method","owner":"sol.common.SordUtils","id":"method-docMaskExists","meta":{}},{"name":"getDecimalSeparatorForIx","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDecimalSeparatorForIx","meta":{}},{"name":"getDecimalSeparatorForLanguage","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDecimalSeparatorForLanguage","meta":{}},{"name":"getDisplayRepoPath","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDisplayRepoPath","meta":{}},{"name":"getDocMask","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDocMask","meta":{}},{"name":"getDocMaskGuid","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDocMaskGuid","meta":{}},{"name":"getDocMaskLine","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDocMaskLine","meta":{}},{"name":"getDocMaskNames","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDocMaskNames","meta":{}},{"name":"getDynamicKeywordlistValue","tagname":"method","owner":"sol.common.SordUtils","id":"method-getDynamicKeywordlistValue","meta":{}},{"name":"getEsw","tagname":"method","owner":"sol.common.SordUtils","id":"method-getEsw","meta":{}},{"name":"getFieldNameIndex","tagname":"method","owner":"sol.common.SordUtils","id":"method-getFieldNameIndex","meta":{}},{"name":"getLinks","tagname":"method","owner":"sol.common.SordUtils","id":"method-getLinks","meta":{}},{"name":"getLocalizedKwlEntry","tagname":"method","owner":"sol.common.SordUtils","id":"method-getLocalizedKwlEntry","meta":{}},{"name":"getLocalizedKwlKey","tagname":"method","owner":"sol.common.SordUtils","id":"method-getLocalizedKwlKey","meta":{}},{"name":"getObjKey","tagname":"method","owner":"sol.common.SordUtils","id":"method-getObjKey","meta":{}},{"name":"getObjKeyValue","tagname":"method","owner":"sol.common.SordUtils","id":"method-getObjKeyValue","meta":{}},{"name":"getObjKeyValueAsNumber","tagname":"method","owner":"sol.common.SordUtils","id":"method-getObjKeyValueAsNumber","meta":{}},{"name":"getObjKeyValues","tagname":"method","owner":"sol.common.SordUtils","id":"method-getObjKeyValues","meta":{}},{"name":"getStatisticSord","tagname":"method","owner":"sol.common.SordUtils","id":"method-getStatisticSord","meta":{}},{"name":"getTemplateSord","tagname":"method","owner":"sol.common.SordUtils","id":"method-getTemplateSord","meta":{}},{"name":"getTimeZoneOffset","tagname":"method","owner":"sol.common.SordUtils","id":"method-getTimeZoneOffset","meta":{"private":true}},{"name":"getValue","tagname":"method","owner":"sol.common.SordUtils","id":"method-getValue","meta":{}},{"name":"getValues","tagname":"method","owner":"sol.common.SordUtils","id":"method-getValues","meta":{}},{"name":"hasDocMask","tagname":"method","owner":"sol.common.SordUtils","id":"method-hasDocMask","meta":{}},{"name":"incObjKeyValue","tagname":"method","owner":"sol.common.SordUtils","id":"method-incObjKeyValue","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isDocument","tagname":"method","owner":"sol.common.SordUtils","id":"method-isDocument","meta":{}},{"name":"isDynamicFolder","tagname":"method","owner":"sol.common.SordUtils","id":"method-isDynamicFolder","meta":{}},{"name":"isFolder","tagname":"method","owner":"sol.common.SordUtils","id":"method-isFolder","meta":{}},{"name":"isIndexdataLoaded","tagname":"method","owner":"sol.common.SordUtils","id":"method-isIndexdataLoaded","meta":{}},{"name":"isSord","tagname":"method","owner":"sol.common.SordUtils","id":"method-isSord","meta":{}},{"name":"isValidNumberFormat","tagname":"method","owner":"sol.common.SordUtils","id":"method-isValidNumberFormat","meta":{}},{"name":"normalizeNumber","tagname":"method","owner":"sol.common.SordUtils","id":"method-normalizeNumber","meta":{}},{"name":"nowIsoForConnection","tagname":"method","owner":"sol.common.SordUtils","id":"method-nowIsoForConnection","meta":{}},{"name":"objKeyExists","tagname":"method","owner":"sol.common.SordUtils","id":"method-objKeyExists","meta":{}},{"name":"setObjKeyValue","tagname":"method","owner":"sol.common.SordUtils","id":"method-setObjKeyValue","meta":{}},{"name":"setObjKeyValueAsNumber","tagname":"method","owner":"sol.common.SordUtils","id":"method-setObjKeyValueAsNumber","meta":{}},{"name":"setObjKeyValues","tagname":"method","owner":"sol.common.SordUtils","id":"method-setObjKeyValues","meta":{}},{"name":"updateKeywording","tagname":"method","owner":"sol.common.SordUtils","id":"method-updateKeywording","meta":{}},{"name":"updateSord","tagname":"method","owner":"sol.common.SordUtils","id":"method-updateSord","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.SordUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.SordUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Cache' rel='sol.common.Cache' class='docClass'>sol.common.Cache</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter' rel='sol.common.ObjectFormatter' class='docClass'>sol.common.ObjectFormatter</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils' target='_blank'>lib_sol.common.SordUtils.js</a></div></pre><div class='doc-contents'><p>This class contains convenience methods for working with Sord objects in server scripts.</p>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-docMaskCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-property-docMaskCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-property-docMaskCache' class='name expandable'>docMaskCache</a> : <a href=\"#!/api/sol.common.Cache\" rel=\"sol.common.Cache\" class=\"docClass\">sol.common.Cache</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>Cache for <code>de.elo.ix.client.DocMask</code></p>\n</div><div class='long'><p>Cache for <code>de.elo.ix.client.DocMask</code></p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-pilcrow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-property-pilcrow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-property-pilcrow' class='name expandable'>pilcrow</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;\\u00b6&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-addRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-addRights' class='name expandable'>addRights</a>( <span class='pre'>sord, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds rights ...</div><div class='long'><p>Adds rights</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>users</span> : Array<div class='sub-desc'><p>Users</p>\n</div></li><li><span class='pre'>rigths</span> : Object<div class='sub-desc'><p>Rights, e.g. { r: true, w: true, d: true, e: true, l: true }</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-changeMask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-changeMask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-changeMask' class='name expandable'>changeMask</a>( <span class='pre'>sord, newMask</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Changes the sord mask ...</div><div class='long'><p>Changes the sord mask</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li><li><span class='pre'>newMask</span> : Number|String<div class='sub-desc'><p>New mask ID or name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-cloneSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-cloneSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-cloneSord' class='name expandable'>cloneSord</a>( <span class='pre'>srcSord, [params]</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Clones a sord. ...</div><div class='long'><p>Clones a sord.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcSord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Source sord</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>dstSord</span> : de.elo.ix.client.Sord (optional)<div class='sub-desc'><p>Destination sord</p>\n</div></li><li><span class='pre'>dstMask</span> : String (optional)<div class='sub-desc'><p>Destination mask</p>\n</div></li><li><span class='pre'>dstParentId</span> : de.elo.ix.client.Sord (optional)<div class='sub-desc'><p>Destination parent ID. Hint: parameter is mandatory if no <code>dstSord</code> is configured</p>\n</div></li><li><span class='pre'>memberNames</span> : String[] (optional)<div class='sub-desc'><p>Member names to copy</p>\n<p>Defaults to: <code>[&quot;name&quot;]</code></p></div></li><li><span class='pre'>objKeyNames</span> : String[] (optional)<div class='sub-desc'><p>Object key names to copy</p>\n</div></li><li><span class='pre'>inheritDestinationAcl</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code> (and the target is a sord) the ACL of the target will be inherited to the cloned sord. Hint: to copy the ACL of the source sord use member <code>aclItems</code> (but <code>inheritDestinationAcl</code> has priority).</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>Sord</p>\n</div></li></ul></div></div></div><div id='method-createSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-createSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-createSord' class='name expandable'>createSord</a>( <span class='pre'>params</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a Sord\n\nBackward-comptabilility added for createSord(maskId, params) ...</div><div class='long'><p>Creates a Sord</p>\n\n<p>Backward-comptabilility added for createSord(maskId, params)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>mask</span> : String<div class='sub-desc'><p>Mask</p>\n</div></li><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Name</p>\n</div></li><li><span class='pre'>parentId</span> : String (optional)<div class='sub-desc'><p>Parent ID</p>\n<p>Defaults to: <code>&quot;1&quot;</code></p></div></li><li><span class='pre'>sortOrder</span> : String<div class='sub-desc'><p>Sort order</p>\n</div></li><li><span class='pre'>containerDocument</span> : String<div class='sub-desc'><p>Container document</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'><p>Sord</p>\n</div></li></ul></div></div></div><div id='method-decObjKeyValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-decObjKeyValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-decObjKeyValue' class='name expandable'>decObjKeyValue</a>( <span class='pre'>sord, keyName</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Decrements the value of an ObjKey ...</div><div class='long'><p>Decrements the value of an ObjKey</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The field value as number</p>\n</div></li></ul></div></div></div><div id='method-docMaskExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-docMaskExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-docMaskExists' class='name expandable'>docMaskExists</a>( <span class='pre'>maskName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a mask exists ...</div><div class='long'><p>Checks wether a mask exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDecimalSeparatorForIx' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDecimalSeparatorForIx' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDecimalSeparatorForIx' class='name expandable'>getDecimalSeparatorForIx</a>( <span class='pre'>conn</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the decimal separator for the ELO index server ...</div><div class='long'><p>Returns the decimal separator for the ELO index server</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>IX connection</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDecimalSeparatorForLanguage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDecimalSeparatorForLanguage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDecimalSeparatorForLanguage' class='name expandable'>getDecimalSeparatorForLanguage</a>( <span class='pre'>language, country</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the decimal separator for a language ...</div><div class='long'><p>Returns the decimal separator for a language</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>language</span> : String<div class='sub-desc'><p>ISO language code to determine the decimal separator</p>\n</div></li><li><span class='pre'>country</span> : String<div class='sub-desc'><p>ISO country code to determine the decimal separator</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDisplayRepoPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDisplayRepoPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDisplayRepoPath' class='name expandable'>getDisplayRepoPath</a>( <span class='pre'>sord, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the display repository path ...</div><div class='long'><p>Returns the display repository path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>separator</span> : String (optional)<div class='sub-desc'><p>Separator</p>\n<p>Defaults to: <code>&quot;/&quot;</code></p></div></li><li><span class='pre'>withName</span> : Boolean (optional)<div class='sub-desc'><p>If true the name of the Sord will be appended</p>\n<p>Defaults to: <code>true</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDocMask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDocMask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDocMask' class='name expandable'>getDocMask</a>( <span class='pre'>name, language</span> ) : de.elo.ix.client.DocMask<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves (and caches) the definition of document masks by their name ...</div><div class='long'><p>Retrieves (and caches) the definition of document masks by their name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>language</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.DocMask</span><div class='sub-desc'><p>mask</p>\n</div></li></ul></div></div></div><div id='method-getDocMaskGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDocMaskGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDocMaskGuid' class='name expandable'>getDocMaskGuid</a>( <span class='pre'>name</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the GUID of a doc mask ...</div><div class='long'><p>Returns the GUID of a doc mask</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Doc mask name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>GUID</p>\n</div></li></ul></div></div></div><div id='method-getDocMaskLine' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDocMaskLine' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDocMaskLine' class='name expandable'>getDocMaskLine</a>( <span class='pre'>maskName, fieldName</span> ) : de.elo.ix.client.DocMaskLine<span class=\"signature\"></span></div><div class='description'><div class='short'>Gets the field information of a specific mask field ...</div><div class='long'><p>Gets the field information of a specific mask field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'><p>Name of the mask</p>\n</div></li><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Name of the field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.DocMaskLine</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDocMaskNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDocMaskNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDocMaskNames' class='name expandable'>getDocMaskNames</a>( <span class='pre'>params</span> ) : de.elo.ix.client.MaskName[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads document mask names ...</div><div class='long'><p>Reads document mask names</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>filter</span> : Object<div class='sub-desc'><p>Filters</p>\n<ul><li><span class='pre'>nameTranslationKeyPrefix</span> : String<div class='sub-desc'><p>Name translation key prefix filter</p>\n</div></li></ul></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.MaskName[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDynamicKeywordlistValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getDynamicKeywordlistValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getDynamicKeywordlistValue' class='name expandable'>getDynamicKeywordlistValue</a>( <span class='pre'>maskName, key, [params]</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves values from a dynamic keyword list. ...</div><div class='long'><p>Retrieves values from a dynamic keyword list.</p>\n\n<p>Returns the values from the KWL associated with the REMINDER_PERIOD_UNIT field</p>\n\n<pre><code><a href=\"#!/api/sol.common.SordUtils-method-getDynamicKeywordlistValue\" rel=\"sol.common.SordUtils-method-getDynamicKeywordlistValue\" class=\"docClass\">sol.common.SordUtils.getDynamicKeywordlistValue</a>(\"Contract\", \"REMINDER_PERIOD_UNIT\");\n</code></pre>\n\n<p>Returns the values from the KWL associated with the REMINDER_PERIOD_UNIT field and containing the string 'month'</p>\n\n<pre><code><a href=\"#!/api/sol.common.SordUtils-method-getDynamicKeywordlistValue\" rel=\"sol.common.SordUtils-method-getDynamicKeywordlistValue\" class=\"docClass\">sol.common.SordUtils.getDynamicKeywordlistValue</a>(\"Contract\", \"REMINDER_PERIOD_UNIT\", { data: \"month\" });\n</code></pre>\n\n<p>Returns the values from the KWL associated with the REMINDER_PERIOD_UNIT field and the data from column 2</p>\n\n<pre><code><a href=\"#!/api/sol.common.SordUtils-method-getDynamicKeywordlistValue\" rel=\"sol.common.SordUtils-method-getDynamicKeywordlistValue\" class=\"docClass\">sol.common.SordUtils.getDynamicKeywordlistValue</a>(\"Contract\", \"REMINDER_PERIOD_UNIT\", { returnColumn: 2 });\n</code></pre>\n\n<p>Returns the values from the KWL associated with the REMINDER_PERIOD_UNIT field and the data from column 2 filtering only thoase containing 'M' in column 1</p>\n\n<pre><code><a href=\"#!/api/sol.common.SordUtils-method-getDynamicKeywordlistValue\" rel=\"sol.common.SordUtils-method-getDynamicKeywordlistValue\" class=\"docClass\">sol.common.SordUtils.getDynamicKeywordlistValue</a>(\"Contract\", \"REMINDER_PERIOD_UNIT\", { data: \"M\", filterColumn: 0, returnColumn: 2 });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'><p>The mask name used to determine the dynamic keyword list</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>The field which has the dynamic keyword list</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>data</span> : String (optional)<div class='sub-desc'><p>lookup data (used to filter the result on the serverside, if supported by the KWL, or on clientside, if <code>returnColumn</code> and <code>filterColumn</code> are defined)</p>\n</div></li><li><span class='pre'>returnColumn</span> : Number (optional)<div class='sub-desc'><p>If set, the content of this column will be returned</p>\n</div></li><li><span class='pre'>filterColumn</span> : Number (optional)<div class='sub-desc'><p>If set (in addition to a return column), the result will be filtered on the clientside on the KWL column with this index (using <code>params.data</code>)</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getEsw' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getEsw' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getEsw' class='name expandable'>getEsw</a>( <span class='pre'>objId, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the ESW content ...</div><div class='long'><p>Returns the ESW content</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>params</span> : String<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>timeZone</span> : Object<div class='sub-desc'><p>Timezone, e.g. <code>GMT</code></p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ESW content</p>\n</div></li></ul></div></div></div><div id='method-getFieldNameIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getFieldNameIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getFieldNameIndex' class='name expandable'>getFieldNameIndex</a>( <span class='pre'>fieldName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the field name index ...</div><div class='long'><p>Returns the field name index</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLinks' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getLinks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getLinks' class='name expandable'>getLinks</a>( <span class='pre'>sord</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Get links ...</div><div class='long'><p>Get links</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>Sord</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>Object IDs</p>\n</div></li></ul></div></div></div><div id='method-getLocalizedKwlEntry' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getLocalizedKwlEntry' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getLocalizedKwlEntry' class='name expandable'>getLocalizedKwlEntry</a>( <span class='pre'>key, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the localized kwl entry ...</div><div class='long'><p>Returns the localized kwl entry</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Key</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>scriptName</span> : String<div class='sub-desc'><p>Script name</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLocalizedKwlKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getLocalizedKwlKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getLocalizedKwlKey' class='name expandable'>getLocalizedKwlKey</a>( <span class='pre'>sord, fieldDef, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the key of a localized keyword list entry ...</div><div class='long'><p>Returns the key of a localized keyword list entry</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>fieldDef</span> : Object<div class='sub-desc'><p>Field definition</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>localizedKwlSeparator</span> : String<div class='sub-desc'><p>Localized keyword list separator</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getObjKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getObjKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getObjKey' class='name expandable'>getObjKey</a>( <span class='pre'>sord, keyName</span> ) : de.elo.ix.client.ObjKey<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the ObjKey for a field ...</div><div class='long'><p>Returns the ObjKey for a field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : string<div class='sub-desc'><p>Name of the index field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.ObjKey</span><div class='sub-desc'><p>The ObjKey, or null if none was found</p>\n</div></li></ul></div></div></div><div id='method-getObjKeyValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getObjKeyValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getObjKeyValue' class='name expandable'>getObjKeyValue</a>( <span class='pre'>sord, keyName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the value of an ObjKey for a field ...</div><div class='long'><p>Returns the value of an ObjKey for a field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The field value</p>\n</div></li></ul></div></div></div><div id='method-getObjKeyValueAsNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getObjKeyValueAsNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getObjKeyValueAsNumber' class='name expandable'>getObjKeyValueAsNumber</a>( <span class='pre'>sord, keyName, params</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the value of an ObjKey for a field as number. ...</div><div class='long'><p>Returns the value of an ObjKey for a field as number.\nThe method takes care of wrong decimal separators.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>throwException</span> : Boolean (optional)<div class='sub-desc'><p>Throw exception</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The field value as number</p>\n</div></li></ul></div></div></div><div id='method-getObjKeyValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getObjKeyValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getObjKeyValues' class='name expandable'>getObjKeyValues</a>( <span class='pre'>sord, keyName</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the values of an ObjKey for a field as array ...</div><div class='long'><p>Returns the values of an ObjKey for a field as array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>The field values</p>\n</div></li></ul></div></div></div><div id='method-getStatisticSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getStatisticSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getStatisticSord' class='name expandable'>getStatisticSord</a>( <span class='pre'>sord</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a statistic sord from a Sord (see StatisticSord). ...</div><div class='long'><p>Creates a statistic sord from a Sord (see <a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">StatisticSord</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplateSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getTemplateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getTemplateSord' class='name expandable'>getTemplateSord</a>( <span class='pre'>sord</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a template sord from a Sord (see TemplateSord). ...</div><div class='long'><p>Creates a template sord from a Sord (see <a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">TemplateSord</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTimeZoneOffset' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getTimeZoneOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getTimeZoneOffset' class='name expandable'>getTimeZoneOffset</a>( <span class='pre'>timeZoneString</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Gets the time zone offset ...</div><div class='long'><p>Gets the time zone offset</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>timeZoneString</span> : String<div class='sub-desc'><p>Time zone string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Offset</p>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>sord, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves a value from a Sord. ...</div><div class='long'><p>Retrieves a value from a Sord.\nThis could be a Sord property, an objKey or a map field.</p>\n\n<p>Map values will only be returned, if there is one result. If there are more results, all will be ignored.</p>\n\n<p>Uses <a href=\"#!/api/sol.common.SordUtils-method-getValues\" rel=\"sol.common.SordUtils-method-getValues\" class=\"docClass\">getValues</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>{\n      key: \"name\",\n      type: \"GRP\", // SORD|GRP|MAP|FORMBLOB\n    }</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-getValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-getValues' class='name expandable'>getValues</a>( <span class='pre'>sord, params</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves values from a Sord. ...</div><div class='long'><p>Retrieves values from a Sord.\nThis could be a Sord property, an objKey, a map field or a form blob field.</p>\n\n<p>This can retrieve lists from <code>ObjKeys</code> and multiple map values.</p>\n\n<pre><code>{\n  key: \"FIELD_NAME\",\n  type: \"GRP\", // SORD|GRP|MAP\n}\n\n{\n  key: \"INDEXED_MAP_FIELD*\",\n  type: \"MAP\", // SORD|GRP|MAP\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Can be null</p>\n</div></li></ul></div></div></div><div id='method-hasDocMask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-hasDocMask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-hasDocMask' class='name expandable'>hasDocMask</a>( <span class='pre'>sord, maskName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a sord has the specified mask ...</div><div class='long'><p>Checks, if a sord has the specified mask</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>maskName</span> : String<div class='sub-desc'><p>The original mask name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-incObjKeyValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-incObjKeyValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-incObjKeyValue' class='name expandable'>incObjKeyValue</a>( <span class='pre'>sord, keyName</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Increments the value of an ObjKey ...</div><div class='long'><p>Increments the value of an ObjKey</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The field value as number</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-isDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-isDocument' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-isDocument' class='name expandable'>isDocument</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a de.elo.ix.client.Sord is from type document ...</div><div class='long'><p>Checks, if a de.elo.ix.client.Sord is from type document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDynamicFolder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-isDynamicFolder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-isDynamicFolder' class='name expandable'>isDynamicFolder</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a de.elo.ix.client.Sord is a dynamic folder. ...</div><div class='long'><p>Checks, if a de.elo.ix.client.Sord is a dynamic folder.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFolder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-isFolder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-isFolder' class='name expandable'>isFolder</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a de.elo.ix.client.Sord is from type folder ...</div><div class='long'><p>Checks, if a de.elo.ix.client.Sord is from type folder</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isIndexdataLoaded' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-isIndexdataLoaded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-isIndexdataLoaded' class='name expandable'>isIndexdataLoaded</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if the index data (objKeys) is loaded ...</div><div class='long'><p>Checks, if the index data (objKeys) is loaded</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-isSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-isSord' class='name expandable'>isSord</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an object is a de.elo.ix.client.Sord ...</div><div class='long'><p>Checks, if an object is a de.elo.ix.client.Sord</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isValidNumberFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-isValidNumberFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-isValidNumberFormat' class='name expandable'>isValidNumberFormat</a>( <span class='pre'>numberString</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the numberString is a valid number ...</div><div class='long'><p>Checks wether the numberString is a valid number</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>numberString</span> : String<div class='sub-desc'><p>Number string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the string contains a valid number</p>\n</div></li></ul></div></div></div><div id='method-normalizeNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-normalizeNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-normalizeNumber' class='name expandable'>normalizeNumber</a>( <span class='pre'>value, language, conn</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Adjusts the decimal separator of a number ...</div><div class='long'><p>Adjusts the decimal separator of a number</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'><p>Value</p>\n</div></li><li><span class='pre'>language</span> : String<div class='sub-desc'><p>ISO country code to determine the decimal separator</p>\n</div></li><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>IX connection</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>normalized Number</p>\n</div></li></ul></div></div></div><div id='method-nowIsoForConnection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-nowIsoForConnection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-nowIsoForConnection' class='name expandable'>nowIsoForConnection</a>( <span class='pre'>[conn], params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns now as ISO date considering the time zone ...</div><div class='long'><p>Returns now as ISO date considering the time zone</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'>\n<p>Defaults to: <code>ixConnect</code></p></div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>startOfDay</span> : Boolean (optional)<div class='sub-desc'><p>Start of day</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ISO date</p>\n</div></li></ul></div></div></div><div id='method-objKeyExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-objKeyExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-objKeyExists' class='name expandable'>objKeyExists</a>( <span class='pre'>sord, keyName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if an ObjKey exists ...</div><div class='long'><p>Checks if an ObjKey exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setObjKeyValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-setObjKeyValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-setObjKeyValue' class='name expandable'>setObjKeyValue</a>( <span class='pre'>sord, keyName, value, params</span> ) : de.elo.ix.client.ObjKey<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the value of an ObjKey for a field ...</div><div class='long'><p>Sets the value of an ObjKey for a field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li><li><span class='pre'>value</span> : String|String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>silent</span> : Boolean<div class='sub-desc'><p>Silent</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.ObjKey</span><div class='sub-desc'><p>The changed ObjKey</p>\n</div></li></ul></div></div></div><div id='method-setObjKeyValueAsNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-setObjKeyValueAsNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-setObjKeyValueAsNumber' class='name expandable'>setObjKeyValueAsNumber</a>( <span class='pre'>sord, keyName, value, [params]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the value of an ObjKey for a field as number. ...</div><div class='long'><p>Sets the value of an ObjKey for a field as number.\nThe method takes care of the decimal separator.</p>\n\n<p>Be carefull if using not the users IX connection to checkin the sord after using this method.\nThis could cause problems with the separator. Use additional <code>params.language</code> parameter where language is the ISO country code of the connection used to checkin the sord afterwards.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>Value</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>language</span> : String (optional)<div class='sub-desc'><p>ISO language code to determine the decimal separator</p>\n</div></li><li><span class='pre'>throwException</span> : Boolean (optional)<div class='sub-desc'><p>Throw exception</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>IX connection</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-setObjKeyValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-setObjKeyValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-setObjKeyValues' class='name expandable'>setObjKeyValues</a>( <span class='pre'>sord, keyName, values, params</span> ) : de.elo.ix.client.ObjKey<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the values of an ObjKey for a field ...</div><div class='long'><p>Sets the values of an ObjKey for a field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>keyName</span> : String<div class='sub-desc'><p>Name of the index field</p>\n</div></li><li><span class='pre'>values</span> : String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>silent</span> : Boolean<div class='sub-desc'><p>Silent</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.ObjKey</span><div class='sub-desc'><p>The changed ObjKey</p>\n</div></li></ul></div></div></div><div id='method-updateKeywording' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-updateKeywording' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-updateKeywording' class='name expandable'>updateKeywording</a>( <span class='pre'>sord, indexData</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Updates a bunch of index data at once. ...</div><div class='long'><p>Updates a bunch of index data at once.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>indexData</span> : Object<div class='sub-desc'><p>Key-value-pairs with key=field and value=new value</p>\n</div></li></ul></div></div></div><div id='method-updateSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.SordUtils'>sol.common.SordUtils</span><br/><a href='source/lib_sol.common.SordUtils.html#sol-common-SordUtils-method-updateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.SordUtils-method-updateSord' class='name expandable'>updateSord</a>( <span class='pre'>sord, data, params</span> ) : de.elo.ix.client.KeyValue[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Updates all of Sord attributes and ObjKeys. ...</div><div class='long'><p>Updates all of Sord attributes and ObjKeys.\nMap Keys are not updated immediately, instead the function returns an Array with KeyValues, which can be checked in later.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : Object[]<div class='sub-desc'><p>{\n      key: \"name\",\n      type: \"GRP\", // SORD|GRP|MAP\n      value: \"hallo welt\"\n    }</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>silent</span> : Boolean<div class='sub-desc'><p>Silent</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.KeyValue[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});